/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeConstants;
import com.ibm.hwmca.base.updates.AnalyzeConsoleIntCodeResponseData;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.List;

public class AnalyzeConsoleIntCodeBean
extends PanelBean
implements AnalyzeConsoleIntCodeConstants,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCFACBT";
    private static final String TRACE_MASKF = "XMCFACBF";
    private static final String TRACE_MASKD = "XMCFACBD";
    private String m_sChngManServOutput;
    private List m_idInterCodeFixesTable = null;
    private ColumnDescriptor[] m_cdInterCodeFixesTableStructure = null;
    private int[] m_iInterCodeFixesTableSelection = null;
    private boolean isChangeConsoleSubtasklet;
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "AnalyzeConsoleIntCodeBean");

    public AnalyzeConsoleIntCodeBean() {
        this.setBeanName("AnalyzeConsoleIntCodePanel");
    }

    public String getChngManServOutput() {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.getChngManServOutput()");
        return this.m_sChngManServOutput;
    }

    public void setChngManServOutput(String s) {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.setChngManServOutput()");
        this.m_sChngManServOutput = s;
    }

    public ColumnDescriptor[] getInterCodeFixesTableRowStructure() {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.getInterCodeFixesTableRowStructure()");
        return this.m_cdInterCodeFixesTableStructure;
    }

    public int getInterCodeFixesTableRowStatus() {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.getInterCodeFixesTableRowStatus()");
        return 3;
    }

    public int getInterCodeFixesTableRowCount() {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.getInterCodeFixesTableRowCount()");
        return null == this.m_idInterCodeFixesTable ? 0 : this.m_idInterCodeFixesTable.size();
    }

    public ItemDescriptor[] getInterCodeFixesTableRowAt(int index) {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.getInterCodeFixesTableRowAt(), index: " + index);
        String[] stringArrayRow = (String[])this.m_idInterCodeFixesTable.get(index);
        ItemDescriptor[] rowData = new ItemDescriptor[]{new ItemDescriptor("ECNumPCol" + index, stringArrayRow[0]), new ItemDescriptor("IDCol" + index, stringArrayRow[1]), new ItemDescriptor("LevelCol" + index, stringArrayRow[2]), new ItemDescriptor("StatusCol" + index, stringArrayRow[3]), new ItemDescriptor("DateCol" + index, stringArrayRow[4]), new ItemDescriptor("TimeCol" + index, stringArrayRow[5]), new ItemDescriptor("DescripCol" + index, stringArrayRow[6])};
        return rowData;
    }

    public void setInterCodeFixesTableRowAt(int index, ItemDescriptor[] items) {
    }

    public int[] getInterCodeFixesTableSelection() {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.getInterCodeFixesTableSelection()");
        return this.m_iInterCodeFixesTableSelection;
    }

    public void setInterCodeFixesTableSelection(int[] selected) {
        Trace.trace(TRACE_MASKD, "<> AnalyzeConsoleIntCodeBean.setInterCodeFixesTableSelection()");
        this.m_iInterCodeFixesTableSelection = selected;
    }

    public void setChangeConsoleSubtaskletStatus(boolean isSubtasklet) {
        this.isChangeConsoleSubtasklet = isSubtasklet;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "<> AnalyzeConsoleIntCodeBean.load()");
    }

    public void prepare() {
        UserTaskManager utm = this.getUserTaskManager();
        if (this.m_idInterCodeFixesTable.size() == 0) {
            utm.setEnabled("FileMenu.DeleteItem", false);
            utm.setEnabled("OptionsMenu.ActInterCodeFixItem", false);
            utm.setEnabled("OptionsMenu.DeActInterCodeFixItem", false);
            utm.setEnabled("ViewMenu.InterCodeFixInfoItem", false);
        }
        if (this.isChangeConsoleSubtasklet) {
            LocalizableText title = new LocalizableText(BaseTextBundle.getBundleName(), "updates.changecons.configspecific.title");
            utm.setCaptionText("AnalyzeConsoleIntCodePanel", title.toString());
            LocalizableText panelText = new LocalizableText(BaseTextBundle.getBundleName(), "updates.changecons.configspecific.panel.text");
            utm.setCaptionText("SelectOneLabel", panelText.toString());
            utm.setShown("FileMenu.DeleteItem", false);
            utm.setShown("FileMenu.RetrieveFromDisketteItem", false);
            utm.setShown("FileMenu.RetrieveFromDvdItem", false);
            utm.setShown("ViewMenu.AccepInterCodeFixItem", false);
        }
    }

    public void update(Object data) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeBean.update()");
        this.refreshData((AnalyzeConsoleIntCodeResponseData)data);
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeBean.update()");
    }

    public void refreshData(AnalyzeConsoleIntCodeResponseData data) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeBean.refreshData()");
        this.m_idInterCodeFixesTable = data.getTableData();
        this.setInterCodeFixesTableSelection(new int[0]);
        this.setChngManServOutput(data.getChangeManagementStatus());
        UserTaskManager utm = this.getUserTaskManager();
        if (null != utm) {
            utm.refreshAllElements();
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeBean.refreshData()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> AnalyzeConsoleIntCodeBean.panelAction()");
        try {
            String command = event.getActionCommand();
            Trace.trace(TRACE_MASKF, " [panelAction()] action command: '" + command + "'.");
            if (command.equalsIgnoreCase("CANCEL")) {
                Trace.trace(TRACE_MASKD, " [panelAction()] CANCEL action command was received.");
                this.dispose();
            } else if (command.equalsIgnoreCase("ViewMenu.AccepInterCodeFixItem") || command.equalsIgnoreCase("FileMenu.RetrieveFromDisketteItem") || command.equalsIgnoreCase("FileMenu.RetrieveFromDvdItem")) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("event", event);
                this.postTaskletRequest(request);
            } else {
                this.getUserTaskManager().storeAllElements();
                int[] selectedRows = this.getInterCodeFixesTableSelection();
                Trace.trace(TRACE_MASKF, " [panelAction()] selected rows = " + selectedRows.length + ".");
                if (command.equalsIgnoreCase("ViewMenu.InterCodeFixInfoItem") && 1 != selectedRows.length) {
                    Trace.trace(TRACE_MASKF, " [panelAction()] Ignore the action. The number of updates selected in the table was" + selectedRows.length + ".");
                    try {
                        CommonMsgApp.showMessageBox(this.getUserTaskManager(), new BaseMessageTitle("MCF8005"), new BaseMessageText("MCF0005"));
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, " [panelAction()] Exception working with message box: ", e);
                    }
                } else if (null != selectedRows && selectedRows.length > 0) {
                    Trace.trace(TRACE_MASKD, " [panelAction()] number of selected rows: " + selectedRows.length);
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData("event", event);
                    request.setData("selected", selectedRows);
                    this.postTaskletRequest(request);
                } else {
                    Trace.trace(TRACE_MASKF, " [panelAction()] Ignore the action. No updates were selected in the table.");
                    try {
                        CommonMsgApp.showMessageBox(this.getUserTaskManager(), new BaseMessageTitle("MCF8004"), new BaseMessageText("MCF0004"));
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, " [panelAction()] Exception working with message box: ", e);
                    }
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, " [panelAction()] exception: " + e);
            new FrameworkLog(classLogInfo, -4350, e).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- AnalyzeConsoleIntCodeBean.panelAction()");
    }
}

